/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.wizard.ActivityCardItemPanel;
import com.quantumdata.sct.gui.wizard.ActivityImageLabel;
import com.quantumdata.sct.gui.wizard.ActivityMainPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;

public class ActivityCardMapPanel
extends SCTPanel {
    private Hashtable m_map;
    private ActivityMainPanel m_mainPanel;
    private CardLayout m_cardLayout;
    private ActivityImageLabel m_imgLabel;

    public ActivityCardMapPanel(ActivityMainPanel activityMainPanel, ActivityImageLabel activityImageLabel) {
        this.m_mainPanel = activityMainPanel;
        this.m_imgLabel = activityImageLabel;
        this.m_map = new Hashtable();
        this.m_cardLayout = new CardLayout();
        this.setLayout(this.m_cardLayout);
    }

    public void addMapCard(String string, ActivityCardItemPanel activityCardItemPanel) {
        super.add(string, activityCardItemPanel);
        this.m_map.put(activityCardItemPanel, string);
        this.m_imgLabel.addItem(string);
    }

    public void clear() {
        Enumeration enumeration = this.m_map.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            String string = (String)this.m_map.get(component);
            super.remove(component);
            this.m_imgLabel.removeItem(string);
        }
        this.m_map.clear();
    }

    public void next() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            ActivityCardItemPanel activityCardItemPanel = (ActivityCardItemPanel)componentArray[i];
            if (!activityCardItemPanel.isVisible()) continue;
            if (!activityCardItemPanel.nextAction()) {
                return;
            }
            int n2 = this.getNextCardIndex(i);
            if (n2 < 0 || n2 > n - 1) {
                this.m_mainPanel.setNextBtnEnabled(false);
                this.m_mainPanel.setFinishBtnEnabled(true);
                return;
            }
            if (n2 == n - 1) {
                this.m_mainPanel.setNextBtnEnabled(false);
                this.m_mainPanel.setFinishBtnEnabled(true);
            } else {
                this.m_mainPanel.setFinishBtnEnabled(false);
            }
            activityCardItemPanel.setVisible(false);
            activityCardItemPanel.postHide();
            activityCardItemPanel = (ActivityCardItemPanel)componentArray[n2];
            activityCardItemPanel.preShow();
            activityCardItemPanel.invalidate();
            activityCardItemPanel.setVisible(true);
            this.m_mainPanel.setBackBtnEnabled(true);
            this.m_imgLabel.selectItem(this.m_map.get(activityCardItemPanel));
            break;
        }
    }

    public ActivityCardItemPanel getCurrentCard() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            if (!componentArray[i].isVisible()) continue;
            return (ActivityCardItemPanel)componentArray[i];
        }
        return null;
    }

    private int getNextCardIndex(int n) {
        int n2 = this.getComponents().length;
        if (n < 0 || n > n2 - 1) {
            return -1;
        }
        for (int i = n + 1; i < n2; ++i) {
            ActivityCardItemPanel activityCardItemPanel = (ActivityCardItemPanel)this.getComponent(i);
            if (this.m_mainPanel.skip(activityCardItemPanel)) continue;
            return i;
        }
        return -1;
    }

    private int getPrevCardIndex(int n) {
        int n2 = this.getComponents().length;
        if (n < 0 || n > n2 - 1) {
            return -1;
        }
        if (n == 0) {
            return 0;
        }
        for (int i = n - 1; i >= 0; --i) {
            ActivityCardItemPanel activityCardItemPanel = (ActivityCardItemPanel)this.getComponent(i);
            if (this.m_mainPanel.skip(activityCardItemPanel)) continue;
            return i;
        }
        return -1;
    }

    public void previous() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            if (!componentArray[i].isVisible()) continue;
            if (!((ActivityCardItemPanel)componentArray[i]).backAction()) {
                return;
            }
            int n2 = this.getPrevCardIndex(i);
            if (n2 < 0 || n2 > n - 1) {
                this.m_mainPanel.setBackBtnEnabled(false);
                this.m_mainPanel.setFinishBtnEnabled(true);
                return;
            }
            if (n2 == 0) {
                this.m_mainPanel.setBackBtnEnabled(false);
            }
            componentArray[i].setVisible(false);
            ((ActivityCardItemPanel)componentArray[i]).postHide();
            ((ActivityCardItemPanel)componentArray[n2]).preShow();
            componentArray[n2].setVisible(true);
            this.m_mainPanel.setNextBtnEnabled(true);
            this.m_mainPanel.setFinishBtnEnabled(false);
            this.m_imgLabel.selectItem(this.m_map.get(componentArray[n2]));
            break;
        }
    }

    public void validateBtn() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        if (n <= 0) {
            this.enableButtons(false);
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (!componentArray[i].isVisible()) continue;
            this.enableButtons(true);
            if (i == 0) {
                this.m_mainPanel.setBackBtnEnabled(false);
                this.m_mainPanel.setFinishBtnEnabled(false);
            }
            if (i == n - 1) {
                this.m_mainPanel.setNextBtnEnabled(false);
                this.m_mainPanel.setFinishBtnEnabled(true);
            }
            this.m_imgLabel.selectItem(this.m_map.get(componentArray[i]));
            break;
        }
    }

    private void enableButtons(boolean bl) {
        this.m_mainPanel.setNextBtnEnabled(bl);
        this.m_mainPanel.setBackBtnEnabled(bl);
        this.m_mainPanel.setFinishBtnEnabled(bl);
    }

    public void showCard(String string) {
        this.m_cardLayout.show(this, string);
        this.validateBtn();
    }
}

